<?php
    $common_settings = session()->get('business.common_settings');
    $multiplier = 1;
    $action = !empty($action) ? $action : '';
    $is_intercompany = request()->boolean('intercompany') || !empty($is_intercompany);

    $tryLoadLotsIfEmpty = function($product) use ($is_intercompany) {
        try {
            if (!empty($product->lot_numbers)) { return $product; }
            if (empty($product->variation_id)) { $product->lot_numbers = []; return $product; }

            $locId = $product->location_id ?? request('location_id');
            $bizId = $product->business_id ?? (auth()->user()->business_id ?? null);

            $base = DB::table('purchase_lines as pl')
                ->leftJoin('purchase_lines as src', function($j){
                    $j->on('src.id', '=', 'pl.parent_purchase_line_id')
                      ->orOn('src.id', '=', 'pl.parent_pl_id')
                      ->orOn('src.id', '=', 'pl.purchase_parent_id');
                })
                ->leftJoin('transactions as t', 't.id', '=', 'pl.transaction_id')
                ->selectRaw("
                    pl.id as purchase_line_id,
                    COALESCE(NULLIF(pl.lot_number,''), NULLIF(src.lot_number,'')) as lot_number,
                    COALESCE(pl.exp_date, src.exp_date) as exp_date,
                    COALESCE(pl.qty_remaining,
                             pl.quantity_remaining,
                             (pl.quantity - COALESCE(pl.quantity_sold,0) - COALESCE(pl.quantity_adjusted,0) + COALESCE(pl.quantity_returned,0)),
                             0
                    ) as qty_available
                ")
                ->where('pl.variation_id', $product->variation_id)
                ->when(!empty($locId), fn($q)=>$q->where('pl.location_id', $locId))
                ->when(!empty($bizId), function($q) use ($bizId){
                    $q->where(function($qq) use ($bizId){
                        $qq->where('t.business_id', $bizId)->orWhereNull('t.business_id');
                    });
                })
                ->where(function($q){
                    $q->whereNotNull('pl.qty_remaining')->where('pl.qty_remaining','>',0)->orWhereNull('pl.qty_remaining');
                })
                ->orderByRaw("COALESCE(pl.exp_date, src.exp_date, '9999-12-31') ASC, pl.id ASC");

            $rows = $base->get();

            if ($rows->count() === 0 && $is_intercompany) {
                $rows = DB::table('purchase_lines as pl')
                    ->leftJoin('purchase_lines as src', function($j){
                        $j->on('src.id', '=', 'pl.parent_purchase_line_id')
                          ->orOn('src.id', '=', 'pl.parent_pl_id')
                          ->orOn('src.id', '=', 'pl.purchase_parent_id');
                    })
                    ->leftJoin('transactions as t', 't.id', '=', 'pl.transaction_id')
                    ->selectRaw("
                        pl.id as purchase_line_id,
                        COALESCE(NULLIF(pl.lot_number,''), NULLIF(src.lot_number,'')) as lot_number,
                        COALESCE(pl.exp_date, src.exp_date) as exp_date,
                        COALESCE(pl.qty_remaining,
                                 pl.quantity_remaining,
                                 (pl.quantity - COALESCE(pl.quantity_sold,0) - COALESCE(pl.quantity_adjusted,0) + COALESCE(pl.quantity_returned,0)),
                                 0
                        ) as qty_available
                    ")
                    ->where('pl.variation_id', $product->variation_id)
                    ->when(!empty($bizId), function($q) use ($bizId){
                        $q->where(function($qq) use ($bizId){
                            $qq->where('t.business_id', $bizId)->orWhereNull('t.business_id');
                        });
                    })
                    ->orderByRaw("COALESCE(pl.exp_date, src.exp_date, '9999-12-31') ASC, pl.id ASC")
                    ->get();
            }

            $product->lot_numbers = $rows->map(function($pl){
                return (object)[
                    'purchase_line_id' => $pl->purchase_line_id,
                    'lot_number'       => $pl->lot_number,
                    'exp_date'         => $pl->exp_date,
                    'qty_available'    => (float)$pl->qty_available,
                ];
            })->all();

        } catch (\Throwable $e) {
            $product->lot_numbers = $product->lot_numbers ?? [];
        }
        return $product;
    };
?>

<?php $__currentLoopData = $sub_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key): ?>
        <?php $multiplier = max(1, (float)$value['multiplier']); ?>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<tr class="product_row" data-row_index="<?php echo e($row_count, false); ?>" <?php if(!empty($so_line)): ?> data-so_id="<?php echo e($so_line->transaction_id, false); ?>" <?php endif; ?>>
    <td>
        <?php if(!empty($so_line)): ?>
            <input type="hidden" name="products[<?php echo e($row_count, false); ?>][so_line_id]" value="<?php echo e($so_line->id, false); ?>">
        <?php endif; ?>

        <?php
            $product_name = $product->product_name . '<br/>' . $product->sub_sku ;
            if(!empty($product->brand)){ $product_name .= ' ' . e($product->brand) ;}
        ?>

        <?php if( ($edit_price || $edit_discount) && empty($is_direct_sell) ): ?>
            <div title="<?php echo app('translator')->get('lang_v1.pos_edit_product_price_help'); ?>" style="display: inline">
                <span class="text-link text-info cursor-pointer" data-toggle="modal" data-target="#row_edit_product_price_modal_<?php echo e($row_count, false); ?>"><?php echo $product_name; ?>&nbsp;<i class="fa fa-info-circle"></i></span>
            </div>
        <?php else: ?>
            <?php echo $product_name; ?>

        <?php endif; ?>

        <img src="<?php if(count($product->media) > 0): ?>
                        <?php echo e($product->media->first()->display_url, false); ?>

                    <?php elseif(!empty($product->product_image)): ?>
                        <?php echo e(asset('/uploads/img/' . rawurlencode($product->product_image)), false); ?>

                    <?php else: ?>
                        <?php echo e(asset('/img/default.png'), false); ?>

                    <?php endif; ?>"
             alt="product-img" loading="lazy" decoding="async" referrerpolicy="no-referrer"
             style="height: 100%;display: inline;margin-left: 3px; border: black;border-radius: 5px; margin-top: 5px; width: 50px;object-fit: cover;">

        <input type="hidden" class="enable_sr_no" value="<?php echo e($product->enable_sr_no, false); ?>">
        <input type="hidden" class="product_type" name="products[<?php echo e($row_count, false); ?>][product_type]" value="<?php echo e($product->product_type, false); ?>">

        <?php
            $hide_tax = session()->get('business.enable_inline_tax') == 1 ? '' : 'hide';
            $tax_id = $product->tax_id;
            $item_tax = !empty($product->item_tax) ? $product->item_tax : 0;
            $unit_price_inc_tax = $product->sell_price_inc_tax;

            if($hide_tax == 'hide'){ $tax_id = null; $unit_price_inc_tax = $product->default_sell_price; }
            if(!empty($so_line) && $action !== 'edit') {
                $tax_id = $so_line->tax_id; $item_tax = $so_line->item_tax; $unit_price_inc_tax = $so_line->unit_price_inc_tax;
            }

            $discount_type = !empty($product->line_discount_type) ? $product->line_discount_type : 'fixed';
            $discount_amount = !empty($product->line_discount_amount) ? $product->line_discount_amount : 0;
            if(!empty($discount)) { $discount_type = $discount->discount_type; $discount_amount = $discount->discount_amount; }
            if(!empty($so_line) && $action !== 'edit') { $discount_type = $so_line->line_discount_type; $discount_amount = $so_line->line_discount_amount; }

            $sell_line_note = !empty($product->sell_line_note) ? $product->sell_line_note : (!empty($so_line) ? $so_line->sell_line_note : '');

            $unit_label = $product->unit ?? '';
            if (!empty($sub_units[$product->sub_unit_id]['name'] ?? null)) { $unit_label = $sub_units[$product->sub_unit_id]['name']; }
        ?>

        <?php if(!empty($discount)): ?>
            <?php echo Form::hidden("products[$row_count][discount_id]", $discount->id); ?>

        <?php endif; ?>

        <?php
            $warranty_id = !empty($action) && $action == 'edit' && !empty($product->warranties->first())  ? $product->warranties->first()->id : $product->warranty_id;
            if($discount_type == 'fixed') { $discount_amount = $discount_amount * $multiplier; }
        ?>

        <?php if(empty($is_direct_sell)): ?>
        <div class="modal fade row_edit_product_price_model" id="row_edit_product_price_modal_<?php echo e($row_count, false); ?>" tabindex="-1" role="dialog">
            <?php echo $__env->make('sale_pos.partials.row_edit_product_price_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php endif; ?>

        <br>
        <?php
            $header_qty = (float)($product->qty_available ?? 0);
            $header_qty_in_selected = $header_qty / max(1, (float)$multiplier);
        ?>
        <small class="text-muted p-1">
            <?php if($product->enable_stock): ?>
                <?php if(isset($obj) && $refererPath!='/pos/create'): ?>
                    <?php echo e(round($header_qty_in_selected), false); ?> <?php echo e($unit_label, false); ?> <?php echo app('translator')->get('lang_v1.in_stock'); ?>
                <?php else: ?>
                    <?php echo e(number_format($header_qty_in_selected, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?> <?php echo e($unit_label, false); ?> <?php echo app('translator')->get('lang_v1.in_stock'); ?>
                <?php endif; ?>
            <?php else: ?>
                --
            <?php endif; ?>
        </small>

        <?php if(in_array('modifiers' , $enabled_modules)): ?>
            <div class="modifiers_html">
                <?php if(!empty($product->product_ms)): ?>
                    <?php echo $__env->make('restaurant.product_modifier_set.modifier_for_product', ['edit_modifiers' => true, 'row_count' => $loop->index, 'product_ms' => $product->product_ms], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php
            $max_quantity_base = (float)($product->qty_available ?? 0);
            $max_quantity = $max_quantity_base / max(1, (float)$multiplier);

            if (!empty($action) && $action == 'edit') {
                if (!empty($so_line)) {
                    $qty_avl_edit = ($so_line->quantity - $so_line->so_quantity_invoiced + $product->quantity_ordered);
                    $max_quantity = (float)$qty_avl_edit / max(1, (float)$multiplier);
                }
            } else {
                if (!empty($so_line) && $so_line->qty_available <= $max_quantity_base) {
                    $max_quantity = (float)$so_line->qty_available / max(1, (float)$multiplier);
                }
            }

            $formatted_header_qty_in_selected = app('App\Utils\Util')->num_f($max_quantity);
            $max_qty_rule = $max_quantity;
            $max_qty_msg  = __('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_header_qty_in_selected, 'unit' => $unit_label]);
        ?>

        
        <?php $product = $tryLoadLotsIfEmpty($product); ?>

        <?php
            $lot_enabled   = session()->get('business.enable_lot_number') == 1;
            $exp_enabled   = session()->get('business.enable_product_expiry') == 1;
            $lot_dropdown_should_show = ($lot_enabled || $exp_enabled) && !empty($product->lot_numbers) && (empty($is_sales_order) || $is_intercompany);
        ?>

        <?php if($lot_dropdown_should_show): ?>
            <select class="form-control lot_number input-sm"
                    name="products[<?php echo e($row_count, false); ?>][lot_no_line_id]"
                    <?php if(!empty($product->transaction_sell_lines_id)): ?> disabled <?php endif; ?>
                    required
                    data-rule-required="true"
                    data-msg-required="<?php echo e(__('Please select Lot & Expiry'), false); ?>">
                <option value=""><?php echo app('translator')->get('lang_v1.lot_n_expiry'); ?></option>

                <?php
                    $header_qty_in_selected = (float) (($product->qty_available ?? 0) / max(1, (float)$multiplier));
                    $unit_label = $product->unit ?? '';
                    if (!empty($sub_units[$product->sub_unit_id]['name'] ?? null)) { $unit_label = $sub_units[$product->sub_unit_id]['name']; }
                    $allow_decimal = !empty($product->unit_allow_decimal) && $product->unit_allow_decimal == 1;
                ?>

                <?php $__currentLoopData = $product->lot_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lot_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $selected = "";
                        $lot_base = max(0, (float)($lot_number->qty_available ?? 0));
                        $lot_sell = $lot_base / max(1, (float)$multiplier);

                        if ($header_qty_in_selected > 0 && $lot_sell > $header_qty_in_selected) {
                            $lot_sell = $header_qty_in_selected;
                        }

                        $lot_rule_qty = $allow_decimal ? $lot_sell : floor($lot_sell);
                        $lot_disp_qty = $allow_decimal
                            ? app('App\Utils\Util')->num_f($lot_sell)
                            : app('App\Utils\Util')->num_f($lot_rule_qty);

                        if(($lot_number->purchase_line_id ?? null) == ($product->lot_no_line_id ?? null)){
                            $selected     = "selected";
                            $max_qty_rule = $lot_rule_qty;
                            $max_qty_msg  = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label]);
                        }

                        $expiry_text = '';
                        if($exp_enabled && !empty($lot_number->exp_date)){
                            try {
                                $is_expired = \Carbon\Carbon::now()->gt(\Carbon\Carbon::createFromFormat('Y-m-d', substr($lot_number->exp_date,0,10)));
                                if($is_expired){ $expiry_text = '(' . __('report.expired') . ')'; }
                            } catch (\Throwable $e) {}
                        }

                        if(!empty($purchase_line_id) && $purchase_line_id == ($lot_number->purchase_line_id ?? null)) {
                            $selected     = "selected";
                            $max_qty_rule = $lot_rule_qty;
                            $max_qty_msg  = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label]);
                        }

                        $label_lot = $lot_number->lot_number ?: 'No lot';
                    ?>

                    <option
                        value="<?php echo e($lot_number->purchase_line_id ?? '', false); ?>"
                        data-qty_available="<?php echo e((float)($lot_number->qty_available ?? 0), false); ?>"
                        data-msg-max="<?php echo app('translator')->get('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label]); ?>"
                        <?php if(!empty($lot_number->exp_date)): ?>
                            <?php $expired = false; try { $expired = \Carbon\Carbon::parse($lot_number->exp_date)->isPast(); } catch(\Throwable $e) {} ?>
                            <?php if($expired): ?> disabled title="<?php echo app('translator')->get('report.expired'); ?>" <?php endif; ?>
                        <?php endif; ?>
                        <?php echo e($selected, false); ?>

                    >
                        <?php echo e($label_lot, false); ?>

                        <?php if($lot_enabled && $exp_enabled): ?> - <?php endif; ?>
                        <?php if($exp_enabled && !empty($lot_number->exp_date)): ?>
                            <?php echo app('translator')->get('product.exp_date'); ?>: <?php echo e(\Carbon::createFromTimestamp(strtotime($lot_number->exp_date))->format(session('business.date_format')), false); ?>

                        <?php endif; ?>
                        <?php echo e($expiry_text, false); ?>

                        — <?php echo e($lot_disp_qty, false); ?> <?php echo e($unit_label, false); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php endif; ?>

        
        <div class="lot-reminder text-danger" style="display:none;margin-top:4px;">
            <i class="fa fa-exclamation-circle"></i>
            <?php echo app('translator')->get('Please select'); ?> <?php echo app('translator')->get('lot & expiry'); ?> <?php echo app('translator')->get('first'); ?> — <?php echo app('translator')->get('then enter quantity'); ?>
        </div>

        <?php if(!empty($is_direct_sell)): ?>
            <br>
            <textarea class="form-control" name="products[<?php echo e($row_count, false); ?>][sell_line_note]" rows="2"><?php echo e($sell_line_note, false); ?></textarea>
            <p class="help-block"><small><?php echo app('translator')->get('lang_v1.sell_line_description_help'); ?></small></p>
        <?php endif; ?>

        <?php if(isset($obj) && $refererPath!='/pos/create'): ?>
            <?php $displayed_locations = []; ?>
            <div class="location-info-container" style="margin-bottom: 10px;">
                <ul class="location-list-header" style="display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; font-weight: bold;">
                    <li style="flex: 3; padding: 5px; border-right: 1px solid #ddd;">Location</li>
                    <li style="flex: 2; padding: 5px; border-right: 1px solid #ddd; text-align: center;">Qty</li>
                    <li style="flex: 2.5; padding: 5px; border-right: 1px solid #ddd; text-align: center;">Lot NO.</li>
                    <li style="flex: 2.5; padding: 5px; text-align: center;">Exp.Date</li>
                </ul>
                <?php $__currentLoopData = $obj; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!in_array($location->name ?? 'unknown', $displayed_locations)): ?>
                        <?php
                            $displayed_locations[] = $location->name ?? 'unknown';
                            try {
                                $purch_obj = DB::table('purchase_lines')->select('lot_number', 'exp_date')->where('product_id', $location->product_id)->first();
                                $lotNumber = $purch_obj->lot_number ?? 'N/A';
                                $expDate = $purch_obj->exp_date ?? 'N/A';
                            } catch (\Throwable $e) {
                                $lotNumber = 'N/A'; $expDate = 'N/A';
                            }
                            $qtyClass = $location->qty_available > 0 ? 'text-success' : 'text-danger';
                        ?>
                        <ul class="location-list-row" style="display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; font-size: 12px;">
                            <li style="flex: 3; padding: 5px; border-right: 1px solid #ddd;"><?php echo e($location->name ?? 'Unknown', false); ?> (<?php echo e($location->last_name ?? '', false); ?>)</li>
                            <li style="flex: 2; padding: 5px; border-right: 1px solid #ddd; text-align: center;" class="<?php echo e($qtyClass, false); ?>"><?php echo e($location->qty_available, false); ?></li>
                            <li style="flex: 2.5; padding: 5px; border-right: 1px solid #ddd; text-align: center;"><?php echo e($lotNumber, false); ?></li>
                            <li style="flex: 2.5; padding: 5px; text-align: center;"><?php echo e($expDate, false); ?></li>
                        </ul>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </td>

    <td>
        <?php if(!empty($product->transaction_sell_lines_id)): ?>
            <input type="hidden" name="products[<?php echo e($row_count, false); ?>][transaction_sell_lines_id]" class="form-control" value="<?php echo e($product->transaction_sell_lines_id, false); ?>">
        <?php endif; ?>

        <input type="hidden" name="products[<?php echo e($row_count, false); ?>][product_id]" class="form-control product_id" value="<?php echo e($product->product_id, false); ?>">
        <input type="hidden" value="<?php echo e($product->variation_id, false); ?>" name="products[<?php echo e($row_count, false); ?>][variation_id]" class="row_variation_id">
        <input type="hidden" value="<?php echo e($product->enable_stock, false); ?>" name="products[<?php echo e($row_count, false); ?>][enable_stock]">

        <?php $allow_decimal = $product->unit_allow_decimal == 1; ?>

        <?php $__currentLoopData = $sub_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key): ?>
                <?php
                    $unit_name = $value['name'];
                    $max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);
                    if(!empty($product->lot_no_line_id)){
                        $max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);
                    }
                    if($value['allow_decimal']) { $allow_decimal = true; }
                ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php
            $has_lot_dropdown   = $lot_dropdown_should_show;
            $no_selected_lot    = empty($product->lot_no_line_id) && empty($purchase_line_id);
            $initial_disable    = $has_lot_dropdown && $no_selected_lot;

            // Original values
            $orig_qty       = (int)($product->quantity_ordered ?? 1);
            $orig_price_inc = $unit_price_inc_tax;
            $orig_price_ex  = !empty($product->unit_price_before_discount) ? $product->unit_price_before_discount : $product->default_sell_price;
            if(!empty($so_line) && $action !== 'edit') { $orig_price_ex = $so_line->unit_price_before_discount; }
            $orig_disc_amt  = !empty($discount_amount) ? $discount_amount : 0;
            $orig_disc_type = $discount_type;
            $orig_subtotal  = $orig_qty * $orig_price_inc;

            // Initial values: show 0 when locked; real values when unlocked
            $init_qty       = $initial_disable ? 0 : $orig_qty;
            $init_min       = $initial_disable ? 0 : 1;
            $init_price_inc = $initial_disable ? 0 : $orig_price_inc;
            $init_price_ex  = $initial_disable ? 0 : $orig_price_ex;
            $init_disc_amt  = $initial_disable ? 0 : $orig_disc_amt;
            $init_subtotal  = $initial_disable ? 0 : $orig_subtotal;
        ?>

        <div class="input-group input-number">
            <span class="input-group-btn">
                <button type="button" class="btn btn-default btn-flat quantity-down" <?php if($initial_disable): ?> disabled <?php endif; ?>>
                    <i class="fa fa-minus text-danger"></i>
                </button>
            </span>

            <input type="text"
                   class="form-control pos_quantity input_number mousetrap input_quantity"
                   name="products[<?php echo e($row_count, false); ?>][quantity]"
                   value="<?php echo e(number_format($init_qty, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
                   data-min="<?php echo e($init_min, false); ?>"
                   data-orig="<?php echo e(number_format($orig_qty, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
                   data-allow-overselling="<?php if(empty($pos_settings['allow_overselling'])): ?><?php echo e('false', false); ?><?php else: ?><?php echo e('true', false); ?><?php endif; ?>"
                   <?php if($allow_decimal): ?> data-decimal="1" <?php else: ?> data-decimal="0" data-rule-abs_digit="true" data-msg-abs_digit="<?php echo app('translator')->get('lang_v1.decimal_value_not_allowed'); ?>" <?php endif; ?>
                   data-rule-required="true" data-msg-required="<?php echo app('translator')->get('validation.custom-messages.this_field_is_required'); ?>"
                   <?php if($product->enable_stock && empty($pos_settings['allow_overselling']) && empty($is_sales_order)): ?>
                        data-rule-max-value="<?php echo e($max_qty_rule, false); ?>"
                        data-qty_available="<?php echo e((float)($product->qty_available ?? 0), false); ?>"
                        data-msg-max-value="<?php echo e($max_qty_msg, false); ?>"
                        data-msg_max_default="<?php echo app('translator')->get('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_header_qty_in_selected, 'unit'=> $unit_label]); ?>"
                   <?php endif; ?>
                   <?php if($initial_disable): ?> disabled <?php endif; ?>
            >

            <span class="input-group-btn">
                <button type="button" class="btn btn-default btn-flat quantity-up" <?php if($initial_disable): ?> disabled <?php endif; ?>>
                    <i class="fa fa-plus text-success"></i>
                </button>
            </span>
        </div>

        
        <input type="hidden" name="products[<?php echo e($row_count, false); ?>][product_unit_id]" value="<?php echo e($product->unit_id, false); ?>">
        <?php if(count($sub_units) > 0): ?>
            <br>
            <select name="products[<?php echo e($row_count, false); ?>][sub_unit_id]" class="form-control input-sm sub_unit">
                <?php $__currentLoopData = $sub_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key, false); ?>" data-multiplier="<?php echo e($value['multiplier'], false); ?>" data-unit_name="<?php echo e($value['name'], false); ?>" data-allow_decimal="<?php echo e($value['allow_decimal'], false); ?>" <?php if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key): ?> selected <?php endif; ?>>
                        <?php echo e($value['name'], false); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           </select>
        <?php else: ?>
            <?php echo e($product->unit, false); ?>

        <?php endif; ?>

        <?php if(!empty($product->second_unit)): ?>
            <br>
            <span style="white-space: nowrap;"><?php echo app('translator')->get('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit]); ?>*:</span><br>
            <input type="text" name="products[<?php echo e($row_count, false); ?>][secondary_unit_quantity]" value="<?php echo e(number_format($product->secondary_unit_quantity, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>" class="form-control input-sm input_number" required>
        <?php endif; ?>

        
        <input type="hidden" class="base_unit_multiplier" name="products[<?php echo e($row_count, false); ?>][base_unit_multiplier]" value="<?php echo e(max(1, (float)$multiplier), false); ?>">
        <input type="hidden" class="hidden_base_unit_sell_price" value="<?php echo e($product->default_sell_price / max(1, (float)$multiplier), false); ?>">

        
        <?php if(!empty($is_direct_sell)): ?>
            <?php $pos_unit_price = $orig_price_ex; ?>
            <input type="hidden" class="orig_pos_unit_price" value="<?php echo e(number_format($pos_unit_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>">
        <?php endif; ?>
    </td>

    <?php if(!empty($is_direct_sell)): ?>
        <?php if(!empty($pos_settings['inline_service_staff'])): ?>
            <td>
                <div class="form-group">
                    <div class="input-group">
                        <?php echo Form::select("products[" . $row_count . "][res_service_staff_id]", $waiters, !empty($product->res_service_staff_id) ? $product->res_service_staff_id : null, ['class' => 'form-control select2 order_line_service_staff', 'placeholder' => __('restaurant.select_service_staff'), 'required' => (!empty($pos_settings['is_service_staff_required']) && $pos_settings['is_service_staff_required'] == 1)]); ?>

                    </div>
                </div>
            </td>
        <?php endif; ?>
        <?php $pos_unit_price = $orig_price_ex; ?>
        <td class="<?php if(!auth()->user()->can('edit_product_price_from_sale_screen')): ?> hide <?php endif; ?>">
            <input type="text"
                   name="products[<?php echo e($row_count, false); ?>][unit_price]"
                   class="form-control pos_unit_price input_number mousetrap"
                   value="<?php echo e(number_format($init_price_ex, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
                   data-orig="<?php echo e(number_format($orig_price_ex, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
                   <?php if($initial_disable): ?> readonly <?php endif; ?>
                   <?php if(!empty($pos_settings['enable_msp'])): ?> data-rule-min-value="<?php echo e($pos_unit_price, false); ?>" data-msg-min-value="<?php echo e(__('lang_v1.minimum_selling_price_error_msg', ['price' => number_format($pos_unit_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator'])]), false); ?>" <?php endif; ?>>
            <?php if(!empty($last_sell_line)): ?>
                <br><small class="text-muted"><?php echo app('translator')->get('lang_v1.prev_unit_price'); ?>: <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $last_sell_line->unit_price_before_discount, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></small>
            <?php endif; ?>
        </td>
        <td <?php if(!$edit_discount): ?> class="hide" <?php endif; ?>>
            <?php echo Form::text("products[$row_count][line_discount_amount]", number_format($init_disc_amt, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input_number row_discount_amount','data-orig'=>number_format($orig_disc_amt, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']),'readonly'=>$initial_disable]); ?><br>
            <?php echo Form::select("products[$row_count][line_discount_type]", ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], $discount_type , ['class' => 'form-control row_discount_type', $initial_disable ? 'disabled' : '']); ?>

            <?php if(!empty($discount)): ?>
                <p class="help-block"><?php echo __('lang_v1.applied_discount_text', ['discount_name' => $discount->name, 'starts_at' => $discount->formated_starts_at, 'ends_at' => $discount->formated_ends_at]); ?></p>
            <?php endif; ?>
        </td>
        <td class="text-center <?php echo e($hide_tax, false); ?>">
            <?php echo Form::hidden("products[$row_count][item_tax]", number_format($item_tax, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'item_tax']); ?>

            <?php echo Form::select("products[$row_count][tax_id]", $tax_dropdown['tax_rates'], $tax_id, ['placeholder' => 'Select', 'class' => 'form-control tax_id'], $tax_dropdown['attributes']); ?>

        </td>
    <?php else: ?>
        <?php if(!empty($pos_settings['inline_service_staff'])): ?>
            <td>
                <div class="form-group">
                    <div class="input-group">
                        <?php echo Form::select("products[" . $row_count . "][res_service_staff_id]", $waiters, !empty($product->res_service_staff_id) ? $product->res_service_staff_id : null, ['class' => 'form-control select2 order_line_service_staff', 'placeholder' => __('restaurant.select_service_staff'), 'required' => (!empty($pos_settings['is_service_staff_required']) && $pos_settings['is_service_staff_required'] == 1)]); ?>

                    </div>
                </div>
            </td>
        <?php endif; ?>
    <?php endif; ?>

    
    <td class="<?php echo e($hide_tax, false); ?>">
        <input type="text"
               name="products[<?php echo e($row_count, false); ?>][unit_price_inc_tax]"
               class="form-control pos_unit_price_inc_tax input_number"
               value="<?php echo e(number_format($init_price_inc, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
               data-orig="<?php echo e(number_format($orig_price_inc, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
               <?php if(!$edit_price || $initial_disable): ?> readonly <?php endif; ?>
               <?php if(!empty($pos_settings['enable_msp'])): ?> data-rule-min-value="<?php echo e($unit_price_inc_tax, false); ?>" data-msg-min-value="<?php echo e(__('lang_v1.minimum_selling_price_error_msg', ['price' => number_format($unit_price_inc_tax, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator'])]), false); ?>" <?php endif; ?>>
    </td>

    
    <td class="text-center">
        <?php $subtotal_type = !empty($pos_settings['is_pos_subtotal_editable']) ? 'text' : 'hidden'; ?>
        <input type="<?php echo e($subtotal_type, false); ?>"
               class="form-control pos_line_total <?php if(!empty($pos_settings['is_pos_subtotal_editable'])): ?> input_number <?php endif; ?>"
               value="<?php echo e(number_format($init_subtotal, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
               data-orig="<?php echo e(number_format($orig_subtotal, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
               <?php if($initial_disable): ?> readonly <?php endif; ?>>
        <span class="display_currency pos_line_total_text <?php if(!empty($pos_settings['is_pos_subtotal_editable'])): ?> hide <?php endif; ?>"
              data-currency_symbol="true"
              data-orig="<?php echo e(number_format($orig_subtotal, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>"
        ><?php echo e(number_format($init_subtotal, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?></span>
    </td>

    <td class="text-center v-center">
        <i class="fa fa-times text-danger pos_remove_row cursor-pointer" aria-hidden="true"></i>
    </td>
</tr>

<style>
.location-info-container { margin-bottom: 10px; font-size: 12px; }
.location-list-header, .location-list-row { display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; }
.location-list-header { font-weight: bold; background-color: #f9f9f9; }
.location-list-header li, .location-list-row li { padding: 5px; border-right: 1px solid #ddd; }
.location-list-header li:last-child, .location-list-row li:last-child { border-right: none; }
.location-list-header li:nth-child(1), .location-list-row li:nth-child(1) { flex: 3; }
.location-list-header li:nth-child(2), .location-list-row li:nth-child(2) { flex: 2; text-align: center; }
.location-list-header li:nth-child(3), .location-list-row li:nth-child(3) { flex: 2.5; text-align: center; }
.location-list-header li:nth-child(4), .location-list-row li:nth-child(4) { flex: 2.5; text-align: center; }
.text-success { color: #28a745; }
.text-danger { color: #dc3545; }
.lot-locked .input_quantity[disabled],
.lot-locked .pos_unit_price_inc_tax[readonly],
.lot-locked .pos_unit_price[readonly],
.lot-locked .row_discount_amount[readonly] { background: #f9f9f9; }
</style>

<script>
(function ($) {
  function setZeroMoney($el) { if ($el.length) { $el.val('0'); $el.trigger('change'); } }
  function setMoney($el, val) { if ($el.length) { $el.val(val); $el.trigger('change'); } }
  function textToZero($el) { if ($el.length) { $el.text('0.00'); } }
  function textToOrig($el) { if ($el.length) { var v=$el.attr('data-orig'); if(v!==undefined) $el.text(v); } }

  // Lock = lot required but not selected: qty must be 0 & disabled.
  // Unlock = lot selected: on the FIRST unlock only, if qty<=0 then set to 1.
  // After first unlock or if user typed a value, never touch qty again.
  function lockRow($row, lock, wasLocked) {
    var $qty    = $row.find('.input_quantity');
    var $btns   = $row.find('.quantity-down, .quantity-up');
    var $priceInc = $row.find('.pos_unit_price_inc_tax');
    var $priceEx  = $row.find('.pos_unit_price'); // direct sell only
    var $discAmt  = $row.find('.row_discount_amount');
    var $discType = $row.find('.row_discount_type');
    var $subIn    = $row.find('.pos_line_total');
    var $subText  = $row.find('.pos_line_total_text');
    var $reminder = $row.find('.lot-reminder');

    // flag when user edits qty (typing or +/- buttons)
    if (!$row.data('qtyUserSetBound')) {
      $row.on('input change', '.input_quantity', function(){ $qty.data('userSet', '1'); });
      $row.on('click', '.quantity-up, .quantity-down', function(){ $qty.data('userSet', '1'); });
      $row.data('qtyUserSetBound', true);
    }

    $row.toggleClass('lot-locked', !!lock);
    $reminder.toggle(!!lock);

    if (lock) {
      // LOCK: force to 0 and disable
      $qty.prop('disabled', true).attr('data-min','0');
      if (parseFloat($qty.val()||'0') !== 0) { $qty.val('0').trigger('change'); }
      $btns.prop('disabled', true);

      // money fields: show 0 while locked
      $priceInc.prop('readonly', true); setZeroMoney($priceInc);
      $priceEx.prop('readonly', true);  setZeroMoney($priceEx);
      $discAmt.prop('readonly', true);  setZeroMoney($discAmt);
      $discType.prop('disabled', true);
      if ($subIn.length) { setZeroMoney($subIn); }
      textToZero($subText);
      return;
    }

    // UNLOCK (lot selected)
    $qty.prop('disabled', false).attr('data-min','1');
    $btns.prop('disabled', false);
    $priceInc.prop('readonly', false);
    if ($priceEx.length){ $priceEx.prop('readonly', false); }
    $discAmt.prop('readonly', false);
    $discType.prop('disabled', false);
    if ($subIn.length) { $subIn.prop('readonly', false); }

    var firstUnlockDone = $row.data('firstUnlockDone') === '1';
    var userSet = $qty.data('userSet') === '1';

    // Only on the first transition from locked->unlocked decide a default qty
    if (wasLocked && !firstUnlockDone && !userSet) {
      var q = parseFloat($qty.val()||'0') || 0;
      if (q <= 0) { $qty.val('1').trigger('change'); }
      $row.data('firstUnlockDone', '1');
    }

    // restore originals ONLY on first unlock so we don't overwrite user edits later
    if (wasLocked && !firstUnlockDone) {
      setMoney($priceInc, $priceInc.attr('data-orig') || $priceInc.val());
      if ($priceEx.length){ setMoney($priceEx, $priceEx.attr('data-orig') || $priceEx.val()); }
      setMoney($discAmt,  $discAmt.attr('data-orig')  || $discAmt.val());
      if ($subIn.length) { setMoney($subIn, $subIn.attr('data-orig') || $subIn.val()); }
      textToOrig($subText);
    }
  }

  function hasRealLots($lot){ return $lot.find('option').length > 1; }

  function reevaluate($row) {
    var $lot = $row.find('select.lot_number');
    if (!$lot.length) return; // no lots for this product

    var lock = hasRealLots($lot) && !$lot.val();
    var wasLocked = $row.data('isLocked') === '1';
    $row.data('isLocked', lock ? '1' : '0');

    lockRow($row, lock, wasLocked);
  }

  // initial pass: evaluate existing rows
  $(function () {
    $('tr.product_row').each(function(){ reevaluate($(this)); });
  });

  // when lot changes (native/select2), re-evaluate only that row
  $(document).on('change select2:select select2:clear', 'select.lot_number', function () {
    reevaluate($(this).closest('tr.product_row'));
  });

  // rows added later → evaluate only the new rows
  var obs = new MutationObserver(function (muts) {
    muts.forEach(function (m) {
      $(m.addedNodes).each(function () {
        var $n = $(this);
        if ($n.is && $n.is('tr.product_row')) { reevaluate($n); }
        if ($n.find) { $n.find('tr.product_row').each(function(){ reevaluate($(this)); }); }
      });
    });
  });
  obs.observe(document.body, { childList: true, subtree: true });
})(jQuery);
</script>
<?php /**PATH /home/adminkim/public_html/resources/views/sale_pos/product_row.blade.php ENDPATH**/ ?>